/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.msgpanel;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgBean;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.msgpanel.MsgActionHandler;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.task.PanelDisplayer;
import com.ibm.hwmca.fw.task.PanelInvoker;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.HMCUserTaskManager;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.UserTaskManager;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public class CommonMsgApp
implements CommonMsgInterface,
PanelInvoker,
HMCSessionListener {
    private boolean panelDone = false;
    private static final String[] BUTTON_NAMES = new String[]{"AButton", "BButton", "CButton", "DButton"};
    private static final String PDML_FILE_NAME = "com.ibm.hwmca.fw.msgpanel.res.CommonMsgRes";
    private static final String PANEL_NAME = "CommonMsgPanel";
    private static final String SMALL_PANEL_NAME = "SmallMsgPanel";
    private static final String TRACE_MASKT = "XFMSGAPT";
    private static final String TRACE_MASKF = "XFMSGAPF";
    private static final String TRACE_MASKD = "XFMSGAPD";
    private static int buttonPressed = 0;
    private UserTaskManager utm = null;
    private CommonMsgBean bean = null;
    private UserTaskManager parent = null;
    private LocalizableText[] options = new LocalizableText[4];
    private LocalizableText title;
    private MessageText[] message;
    private String msgId;
    private MsgType type;
    private boolean UTMcreated = false;
    private boolean panelFinished = false;
    private Object dispLock = new Object();

    private CommonMsgApp(UserTaskManager parent, LocalizableText title, MessageText[] message, String msgId, MsgType type, LocalizableText[] options) throws HException {
        Trace.trace(TRACE_MASKF, "Here in CommonMsgApp Constructor");
        Trace.trace(TRACE_MASKF, "message = " + message[0]);
        Trace.trace(TRACE_MASKF, "message id = " + msgId);
        Trace.trace(TRACE_MASKF, "message type = " + type);
        this.parent = parent;
        Trace.trace(TRACE_MASKF, "->CommonMsgApp parent = " + parent);
        this.title = title;
        this.message = message;
        this.msgId = msgId;
        this.type = type;
        this.options = options;
        Trace.trace(TRACE_MASKT, "<> CommonMsgApp.ctor()");
    }

    public static LocalizableText showMessageBox(UserTaskManager parent, LocalizableText title, MessageText message) throws HException {
        return CommonMsgApp.showMessageBox(parent, title, message, null);
    }

    public static LocalizableText showMessageBox(UserTaskManager parent, LocalizableText title, MessageText message, MsgType type) throws HException {
        return CommonMsgApp.showMessageBox(parent, title, message, type, null);
    }

    public static LocalizableText showMessageBox(UserTaskManager parent, LocalizableText title, MessageText message, MsgType type, LocalizableText[] options) throws HException {
        try {
            MessageText[] messageArray = new MessageText[]{message};
            return CommonMsgApp.showMessageBox(parent, title, messageArray, message.getMsgId(), type, options);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
            HException hexc = new HException(e);
            throw hexc;
        }
    }

    public static LocalizableText showMessageBox(UserTaskManager parent, LocalizableText title, MessageText[] message, String msgId) throws HException {
        return CommonMsgApp.showMessageBox(parent, title, message, msgId, null);
    }

    public static LocalizableText showMessageBox(UserTaskManager parent, LocalizableText title, MessageText[] message, String msgId, MsgType type) throws HException {
        return CommonMsgApp.showMessageBox(parent, title, message, msgId, type, null);
    }

    public static LocalizableText showMessageBox(UserTaskManager parent, LocalizableText title, MessageText[] message, String msgId, MsgType type, LocalizableText[] options) throws HException {
        return new CommonMsgApp(parent, title, message, msgId, type, options).show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LocalizableText show() throws HException {
        Trace.trace(TRACE_MASKT, "-> CommonMsgApp.show()");
        try {
            PanelDisplayer.display(this);
            CommonMsgApp commonMsgApp = this;
            synchronized (commonMsgApp) {
                while (!this.UTMcreated) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException exc) {
                        // empty catch block
                    }
                }
            }
            this.utm.invoke();
            if (this.parent == null) {
                this.panelDone = false;
                MsgEventQueue theQueue = null;
                if (EventQueue.isDispatchThread()) {
                    theQueue = new MsgEventQueue();
                }
                CommonMsgApp commonMsgApp2 = this;
                synchronized (commonMsgApp2) {
                    while (!this.panelDone) {
                        try {
                            if (theQueue == null) {
                                this.wait();
                            } else {
                                theQueue.processOneEvent();
                            }
                            Trace.trace(TRACE_MASKF, "buttonPressed = " + buttonPressed);
                        }
                        catch (InterruptedException exc) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            HException hexc = new HException(exc);
            throw hexc;
        }
        LocalizableText returnButton = null;
        if (buttonPressed < 4) {
            returnButton = this.options[buttonPressed];
        } else if (buttonPressed == 4) {
            returnButton = CommonMsgInterface.CLOSE_BUTTON;
        }
        Trace.trace(TRACE_MASKT, "<- CommonMsgApp.show()");
        return returnButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doButton(int button) {
        Object object;
        Trace.trace(TRACE_MASKT, "-> CommonMsgApp.doButton");
        buttonPressed = button;
        if (this.parent == null) {
            object = this;
            synchronized (object) {
                this.panelDone = true;
                this.notifyAll();
            }
        }
        object = this.dispLock;
        synchronized (object) {
            this.panelFinished = true;
            this.dispLock.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- CommonMsgApp.doButton");
    }

    public static boolean showDataChangedConfirmation(UserTaskManager parent) {
        boolean endit;
        block4: {
            try {
                LocalizableText title = new LocalizableText("com/ibm/hwmca/fw/res/common", "cancel.confirm.title");
                LocalizableText msg = new LocalizableText("com/ibm/hwmca/fw/res/common", "cancel.confirm.text");
                MessageText txt = new MessageText(null, "          " + msg.toString());
                LocalizableText ans = CommonMsgApp.showMessageBox(parent, title, txt, MsgType.QUESTION_MESSAGE);
                if (ans == null || ans.equals(CommonMsgInterface.NO_BUTTON)) {
                    endit = false;
                    break block4;
                }
                if (ans.equals(CommonMsgInterface.YES_BUTTON)) {
                    endit = true;
                    break block4;
                }
                endit = false;
            }
            catch (Exception e) {
                endit = false;
            }
        }
        return endit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws HException {
        String msgIdMinusType = null;
        Trace.trace(TRACE_MASKT, "-> CommonMsgApp.invoke()");
        CommonMsgApp commonMsgApp = this;
        synchronized (commonMsgApp) {
            try {
                int forLength = 0;
                boolean multipleLines = false;
                if (this.msgId == null) {
                    this.msgId = this.message[0].getMsgId();
                    msgIdMinusType = this.message[0].getMsgIdMinusType();
                    if (this.type == null) {
                        this.type = this.message[0].getMsgType();
                    }
                } else {
                    msgIdMinusType = this.msgId.substring(0, this.msgId.length() - 1);
                    if (this.type == null) {
                        this.type = MessageText.getMsgType(this.msgId);
                    }
                }
                if (this.options == null) {
                    LocalizableText[] localOptions;
                    if (this.type.equals(MsgType.WARNING_MESSAGE)) {
                        localOptions = new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON};
                        this.options = localOptions;
                    } else if (this.type.equals(MsgType.QUESTION_MESSAGE)) {
                        localOptions = new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON};
                        this.options = localOptions;
                    } else {
                        localOptions = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                        this.options = localOptions;
                    }
                }
                StringBuffer SBMessage = new StringBuffer();
                SBMessage.append("<HTML>");
                forLength = this.message.length;
                int msgCnt = 0;
                while (msgCnt < forLength) {
                    String brokenString = this.parseMessage(this.message[msgCnt].toString());
                    if (SBMessage.length() == 0) {
                        SBMessage.append(brokenString);
                    } else {
                        SBMessage.append("<BR><BR>");
                        SBMessage.append(brokenString);
                    }
                    ++msgCnt;
                }
                SBMessage.append("</HTML>");
                CommonMsgBean bean = new CommonMsgBean();
                bean.load();
                Trace.trace(TRACE_MASKF, "message id = " + this.msgId);
                this.bean = bean;
                Object[] dataBeans = new DataBean[]{this.bean};
                this.bean.setMsgIdLabel(msgIdMinusType);
                Trace.trace(TRACE_MASKF, "PDML file = com.ibm.hwmca.fw.msgpanel.res.CommonMsgRes");
                Trace.trace(TRACE_MASKF, "PDML panel = CommonMsgPanel");
                Trace.trace(TRACE_MASKF, "the beans = " + dataBeans[0]);
                Properties utmProp = new Properties();
                String helpkey = new String();
                String helpInfo = new String();
                forLength = this.options.length;
                int buttons = 0;
                while (buttons < forLength) {
                    if (this.options[buttons].equals(CommonMsgInterface.HELP_BUTTON)) {
                        String bundle = this.message[0].getResourceBundleName();
                        helpkey = this.msgId + ".help";
                        helpInfo = CommonResourceBundle.getString(bundle, Locale.getDefault(), helpkey);
                        Trace.trace(TRACE_MASKF, "HELP KEY = " + helpkey);
                        Trace.trace(TRACE_MASKF, "HELP Info = " + helpInfo);
                        if (helpInfo != helpkey) {
                            utmProp.put("@CommonMsgPanel", helpInfo);
                        }
                    }
                    ++buttons;
                }
                Object userContext = null;
                this.utm = this.parent != null ? new HMCUserTaskManager(PDML_FILE_NAME, utmProp, PANEL_NAME, dataBeans, null, this.parent) : new HMCUserTaskManager(PDML_FILE_NAME, utmProp, PANEL_NAME, dataBeans, null, (Object)userContext);
                this.utm.setCaptionText("MsgTextLabel", SBMessage.toString());
                Trace.trace(TRACE_MASKD, "panel CommonMsgPanel");
                Trace.trace(TRACE_MASKD, "message title to be set to " + this.title.toString());
                this.utm.setCaptionText(PANEL_NAME, this.title.toString());
                int buttons2 = 0;
                while (buttons2 < 4) {
                    this.utm.setShown(BUTTON_NAMES[buttons2], false);
                    ++buttons2;
                }
                forLength = this.options.length;
                int buttons3 = 0;
                while (buttons3 < forLength) {
                    System.out.println("button name is " + this.options[buttons3].toString());
                    if (this.options[buttons3].equals(CommonMsgInterface.HELP_BUTTON)) {
                        System.out.println("show help button");
                        this.utm.setShown("HelpButton", true);
                        if (helpInfo == helpkey) {
                            this.utm.setEnabled("HelpButton", false);
                        }
                    } else {
                        this.utm.setCaptionText(BUTTON_NAMES[buttons3], this.options[buttons3].toString());
                        this.options[buttons3] = this.options[buttons3];
                        this.utm.setShown(BUTTON_NAMES[buttons3], true);
                    }
                    ++buttons3;
                }
                String typeKey = (String)this.type.getValue();
                if (this.type.equals(MsgType.ERROR_MESSAGE)) {
                    this.utm.setCaptionImageSrc("MsgTextLabel", "com/ibm/hwmca/fw/images/error.gif");
                } else if (this.type.equals(MsgType.WARNING_MESSAGE)) {
                    this.utm.setCaptionImageSrc("MsgTextLabel", "com/ibm/hwmca/fw/images/except.gif");
                } else if (this.type.equals(MsgType.QUESTION_MESSAGE)) {
                    this.utm.setCaptionImageSrc("MsgTextLabel", "com/ibm/hwmca/fw/images/help.gif");
                } else {
                    this.utm.setCaptionImageSrc("MsgTextLabel", "com/ibm/hwmca/fw/images/info.gif");
                }
                MsgActionHandler msgActionHandler = new MsgActionHandler();
                this.utm.addCancelListener((TaskActionListener)msgActionHandler);
                this.bean.setApp(this);
                this.UTMcreated = true;
                this.notifyAll();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, e);
                if (this.utm != null) {
                    this.utm.dispose();
                }
                HException hexc = new HException(e);
                throw hexc;
            }
        }
        Trace.trace(TRACE_MASKT, "<- CommonMsgApp.invoke()");
    }

    public String parseMessage(String message) {
        StringBuffer rtrnStringBuffer = null;
        try {
            if (message.length() < 80 || message.indexOf("<br>") >= 0 || message.indexOf("<BR>") >= 0) {
                Trace.trace(TRACE_MASKD, "just returning the message ");
                return message;
            }
            StringTokenizer sT = new StringTokenizer(message);
            StringBuffer sB = new StringBuffer();
            rtrnStringBuffer = new StringBuffer();
            while (sT.hasMoreTokens()) {
                sB.append(sT.nextToken() + " ");
                Trace.trace(TRACE_MASKD, "sb.length is  " + sB.length());
                if (sB.length() <= 80) continue;
                sB.append("<br>");
                rtrnStringBuffer.append(sB.toString());
                sB = sB.delete(0, sB.length());
            }
            if (sB != null) {
                rtrnStringBuffer.append(sB.toString());
            }
        }
        catch (Exception e) {
            return message;
        }
        return rtrnStringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitForComplete() {
        Trace.trace(TRACE_MASKT, "-> CommonMsgApp.waitForComplete()");
        Object object = this.dispLock;
        synchronized (object) {
            while (!this.panelFinished) {
                try {
                    this.dispLock.wait();
                }
                catch (InterruptedException exc) {
                    // empty catch block
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- CommonMsgApp.waitForComplete()");
    }

    public String getCallerId() {
        return new String("CommonMsgApp");
    }

    public boolean registerAsHMCSessionListener() {
        return true;
    }

    public void sessionDisconnected(HMCSession session) {
        Trace.trace(TRACE_MASKT, "-> CommonMsgApp.sessionDisconnected()");
        this.doButton(4);
        if (this.utm != null) {
            this.utm.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- CommonMsgApp.sessionDisconnected()");
    }

    public void sessionConnected(HMCSession session) {
    }

    public void sessionDestroyed(HMCSession session) {
    }

    public void clientConnectivityLost(HMCSession session) {
    }

    public void clientConnectivityGained(HMCSession session) {
    }

    public void taskStarted(HMCSession session, PanelModelTaskPortal portal) {
    }

    public void taskEnded(HMCSession session, PanelModelTaskPortal portal) {
    }

    public void taskRealized(HMCSession session, PanelModelTaskPortal portal) {
    }

    private class MsgEventQueue
    extends EventQueue {
        private EventQueue sysQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();

        MsgEventQueue() {
        }

        private void processOneEvent() {
            try {
                this.dispatchEvent(this.sysQueue.getNextEvent());
            }
            catch (InterruptedException e) {}
        }
    }
}

